// Tags which are used to distinguish between the different recipient fields - To/CC/BCC
// They are initialized by the native code via init(). The values present here are the default values.
var TAG_TO_RECIPIENT = 11;
var TAG_CC_RECIPIENT = 12;
var TAG_BCC_RECIPIENT = 13;
var INVALID_CURSOR_OFFSET = -1;

// Constants which store element IDs
var COMPOSE_HEADER_ELEMENT_ID = "ymail_composeHeader";
var COMPOSE_CONTENT_ELEMENT_ID = "ymail_composeContent";

var TO_ROW_ELEMENT_ID = "ymail_toRow";
var TO_LABEL_ELEMENT_ID = 'ymail_toLabel';
var CC_ROW_ELEMENT_ID = "ymail_ccRow";
var CC_LABEL_ELEMENT_ID = 'ymail_ccLabel';
var BCC_ROW_ELEMENT_ID = "ymail_bccRow";
var BCC_LABEL_ELEMENT_ID = 'ymail_bccLabel';
var FROM_ROW_ELEMENT_ID = "ymail_fromRow";
var FROM_LABEL_ELEMENT_ID = 'ymail_fromLabel';
var CC_BCC_FROM_SUMMARY_ROW_ELEMENT_ID = "ymail_ccBccFromSummaryRow";
var SUBJECT_ROW_ELEMENT_ID = "ymail_subjectRow";
var ATTACHMENTS_ROW_ELEMENT_ID = "ymail_attachmentsRow";
var ATTACHMENTS_LABEL_ELEMENT_ID = "ymail_attachmentsLabel";

var CC_BCC_FROM_SUMMARY_ROW_TEXT_ELEMENT_ID = "ymail_ccBccFromSummaryRowText";

var SELECTED_FROM_ADDRESS_ELEMENT_ID = "ymail_selectedFromAddress";

var SECURITY_NOTIFICATION_BOX_USER_ID = "ymail_security_notification_user";
var SECURITY_NOTIFICATION_TITLE_USER_ID = "ymail_security_notification_title_user";
var SECURITY_NOTIFICATION_BODY_TEXT_ID = "ymail_security_notification_body_text";
var SECURITY_NOTIFICATION_BODY_EMAIL_USER_ID = "ymail_security_notification_body_email";
var SECURITY_NOTIFICATION_HELP_ID = "ymail_security_notification_help";
var SECURITY_NOTIFICATION_CLOSE_ID = "ymail_security_notification_close";

var TO_LOZENGE_CONTAINER_ELEMENT_ID = "ymail_toLozengeContainer";
var CC_LOZENGE_CONTAINER_ELEMENT_ID = "ymail_ccLozengeContainer";
var BCC_LOZENGE_CONTAINER_ELEMENT_ID = "ymail_bccLozengeContainer";

var TO_INPUT_ELEMENT_ID = "ymail_toInput";
var CC_INPUT_ELEMENT_ID = "ymail_ccInput";
var BCC_INPUT_ELEMENT_ID = "ymail_bccInput";

var SEARCH_SUGGESTION_ELEMENT_ID = "ymail_contactSearchSuggestionsContainer";

var TO_LOZENGE_SUMMARY_ELEMENT_ID = "ymail_toLozengeSummary";
var CC_LOZENGE_SUMMARY_ELEMENT_ID = "ymail_ccLozengeSummary";
var BCC_LOZENGE_SUMMARY_ELEMENT_ID = "ymail_bccLozengeSummary";

var SUBJECT_INPUT_ELEMENT_ID = "ymail_subjectField";
var SUBJECT_HINT_COLOR_CODE = '#b9bdc5';

var ATTACHMENTS_ELEMENT_ID = "ymail_attachments";
var SIGNATURE_ELEMENT_ID = "ymail_android_signature";

var NO_CACHE_QUERY_PARAM = '';
var NONE_STATIONERY_ID = 'NONE';
var STATIONERY_BODY_ID = 'middleBody';

// Keycode representing Enter
var KEYCODE_ENTER = 13;

/**
 * Called from Java to initialize constants.
 *
 * @param {number} invalidCursorOffset
 * @param {number} toTag
 * @param {number} ccTag
 * @param {number} bccTag
 * @param {string} noCacheQueryParam
 * @param {string} signatureElementId
 * @param {number} logLevel
 * @param {string} toString
 * @param {string} ccString
 * @param {string} bccString
 * @param {string} subjectString
 * @param {string} fromString
 * @param {string} accessibilityComposeContent
 */
function initConstants(invalidCursorOffset, toTag, ccTag, bccTag, noCacheQueryParam, signatureElementId, logLevel,
        toString, ccString, bccString, subjectString, fromString, accessibilityComposeContent, noneStationeryId, subjectHintColorCode) {
    var subjectInputEl = document.getElementById(SUBJECT_INPUT_ELEMENT_ID);
    // Set cursor position
    INVALID_CURSOR_OFFSET = invalidCursorOffset;

    // Subject hint color
    SUBJECT_HINT_COLOR_CODE = subjectHintColorCode;

    // Set recipient field tag values
    TAG_TO_RECIPIENT = toTag;
    TAG_CC_RECIPIENT = ccTag;
    TAG_BCC_RECIPIENT = bccTag;

    NO_CACHE_QUERY_PARAM = noCacheQueryParam;
    NONE_STATIONERY_ID = noneStationeryId;

    // Set signature id
    SIGNATURE_ELEMENT_ID = signatureElementId;

    window.logLevel = logLevel;

    // Initialize text with correct translations
    document.getElementById(TO_LABEL_ELEMENT_ID).textContent = toString;
    document.getElementById(CC_LABEL_ELEMENT_ID).textContent = ccString;
    document.getElementById(BCC_LABEL_ELEMENT_ID).textContent = bccString;
    document.getElementById(FROM_LABEL_ELEMENT_ID).textContent = fromString;
    document.getElementById(COMPOSE_CONTENT_ELEMENT_ID).setAttribute('aria-label', accessibilityComposeContent);
    subjectInputEl.setAttribute('placeholder', subjectString);
}

/**
 * Called from Java to initialize the JavaScript application
 */
function init() {
    // Store node references
    var headerContainerElement = document.getElementById(COMPOSE_HEADER_ELEMENT_ID);
    var composeContentElement =  document.getElementById(COMPOSE_CONTENT_ELEMENT_ID);

    var toRowElement = document.getElementById(TO_ROW_ELEMENT_ID);
    var ccRowElement = document.getElementById(CC_ROW_ELEMENT_ID);
    var bccRowElement = document.getElementById(BCC_ROW_ELEMENT_ID);
    var fromRowElement = document.getElementById(FROM_ROW_ELEMENT_ID);
    var ccBccFromSummaryRowElement = document.getElementById(CC_BCC_FROM_SUMMARY_ROW_ELEMENT_ID);
    var subjectRowElement = document.getElementById(SUBJECT_ROW_ELEMENT_ID);
    var attachmentsRowElement = document.getElementById(ATTACHMENTS_ROW_ELEMENT_ID);

    var ccBccFromSummaryRowTextElement = document.getElementById(CC_BCC_FROM_SUMMARY_ROW_TEXT_ELEMENT_ID);
    var fromAddressTextElement = document.getElementById(SELECTED_FROM_ADDRESS_ELEMENT_ID);

    var toLozengeContainerElement = document.getElementById(TO_LOZENGE_CONTAINER_ELEMENT_ID);
    var ccLozengeContainerElement = document.getElementById(CC_LOZENGE_CONTAINER_ELEMENT_ID);
    var bccLozengeContainerElement = document.getElementById(BCC_LOZENGE_CONTAINER_ELEMENT_ID);

    var toInputElement = document.getElementById(TO_INPUT_ELEMENT_ID);
    var ccInputElement = document.getElementById(CC_INPUT_ELEMENT_ID);
    var bccInputElement = document.getElementById(BCC_INPUT_ELEMENT_ID);

    var searchSuggestionElement = document.getElementById(SEARCH_SUGGESTION_ELEMENT_ID);

    var toLozengeSummaryElement = document.getElementById(TO_LOZENGE_SUMMARY_ELEMENT_ID);
    var ccLozengeSummaryElement = document.getElementById(CC_LOZENGE_SUMMARY_ELEMENT_ID);
    var bccLozengeSummaryElement = document.getElementById(BCC_LOZENGE_SUMMARY_ELEMENT_ID);

    var subjectInputElement = document.getElementById(SUBJECT_INPUT_ELEMENT_ID);

    var attachmentsLabelElement = document.getElementById(ATTACHMENTS_LABEL_ELEMENT_ID);

    var attachmentsElement = document.getElementById(ATTACHMENTS_ELEMENT_ID);

    var securityNotificationElement = document.getElementById(SECURITY_NOTIFICATION_BOX_USER_ID)

    // Start lozenges controller
    lozengeController.create(headerContainerElement, composeContentElement, toRowElement, toLozengeContainerElement, toLozengeSummaryElement, toInputElement, TAG_TO_RECIPIENT);
    lozengeController.create(headerContainerElement, composeContentElement, ccRowElement, ccLozengeContainerElement, ccLozengeSummaryElement, ccInputElement, TAG_CC_RECIPIENT);
    lozengeController.create(headerContainerElement, composeContentElement, bccRowElement, bccLozengeContainerElement, bccLozengeSummaryElement, bccInputElement, TAG_BCC_RECIPIENT);

    // Start the type ahead contact search controller
    contactSearchController.create(toInputElement, searchSuggestionElement, toRowElement,
            [ccRowElement, bccRowElement, fromRowElement, ccBccFromSummaryRowElement, subjectRowElement, attachmentsRowElement, composeContentElement, securityNotificationElement],
            TAG_TO_RECIPIENT);
    contactSearchController.create(ccInputElement, searchSuggestionElement, ccRowElement,
            [toRowElement, bccRowElement, fromRowElement, ccBccFromSummaryRowElement, subjectRowElement, attachmentsRowElement, composeContentElement, securityNotificationElement],
            TAG_CC_RECIPIENT);
    contactSearchController.create(bccInputElement, searchSuggestionElement, bccRowElement,
            [toRowElement, ccRowElement, fromRowElement, ccBccFromSummaryRowElement, subjectRowElement, attachmentsRowElement, composeContentElement, securityNotificationElement],
            TAG_BCC_RECIPIENT);

    var toSuggestions = document.getElementById("ymail_to_contactRelatedContainer");
    var ccSuggestions = document.getElementById("ymail_cc_contactRelatedContainer");
    var bccSuggestions = document.getElementById("ymail_bcc_contactRelatedContainer");
    contactRelatedController.create(toInputElement, toSuggestions, toRowElement, TAG_TO_RECIPIENT);
    contactRelatedController.create(ccInputElement, ccSuggestions, ccRowElement, TAG_CC_RECIPIENT);
    contactRelatedController.create(bccInputElement, bccSuggestions, bccRowElement, TAG_BCC_RECIPIENT);

    // Start CC/BCC/From summary control logic
    ccBccFromSummaryFieldController.init(ccBccFromSummaryRowElement, ccBccFromSummaryRowTextElement, headerContainerElement, ccRowElement, ccInputElement,
            bccInputElement, bccRowElement, fromRowElement, fromAddressTextElement, ccLozengeContainerElement, bccLozengeContainerElement, CC_INPUT_ELEMENT_ID, BCC_INPUT_ELEMENT_ID);

    // Subject watcher
    subjectTextController.init(subjectRowElement, subjectInputElement);

    // Attachments controller
    attachmentsController.init(attachmentsRowElement, attachmentsElement, attachmentsLabelElement, composeContentElement);

    // Start the global focus tracker, so that we can restore the focus correct on configuration change
    document.body.addEventListener('focus', globalFocusTracker, true);

    // Start the auto save controller
    autoSaveController.init(composeContentElement);

    // Start the compose content focus controller
    composeContentFocusController.init(composeContentElement);

    // Start the tap to delete image controller
    imageTapDeleteController.init(composeContentElement);

    // listen for URLs being inserted by the user
    LinkExtractor.watch(composeContentElement);

    // Add click listener on the body
    composeContentElement.addEventListener('click', function(e) {
        e.preventDefault();
        yMailBridge.bodyClick();
    });

    // NOTE : Fix this. Color change is not working
    subjectRowElement.setAttribute('style', 'color:' + SUBJECT_HINT_COLOR_CODE);

    // Keydown event handler on headerRow, auto focus to next input field when enter is pressed
    headerContainerElement.addEventListener("keydown",function(e) {
        var targetEl = e.target,
            code = e.keyCode || e.which;

        if (code === KEYCODE_ENTER) {
            switch (targetEl.id) {
                case TO_INPUT_ELEMENT_ID:
                    if (ymail_ccRow.classList && ymail_ccRow.classList.contains('hidden')) {
                        subjectInputElement.focus();
                    } else {
                        lozengeController.expandLozenges(TAG_CC_RECIPIENT);
                        ccInputElement.focus();
                    }
                    break;
                case CC_INPUT_ELEMENT_ID:
                    lozengeController.expandLozenges(TAG_BCC_RECIPIENT);
                    bccInputElement.focus();
                    break;
                case BCC_INPUT_ELEMENT_ID:
                    subjectInputElement.focus();
                    break;
                case SUBJECT_INPUT_ELEMENT_ID:
                    composeContentFocusController.focusContentNode();
                    break;
                default:
                    break;
            }
        }
    });

}

/**
 * Tracks the currently focused element and saves the id of the element through native code.
 * Used to restore the focus after configuration changes such as device rotations.
 *
 * @param event the JavaScript FocusEvent object
 */
function globalFocusTracker(event) {
    if (event.target.id != "") {
        contactRelatedController.close(event.target.id);
    }
    yMailBridge.setCurrentlyFocusedElementId(event.target.id);
    yMailBridge.setCurrentlyFocusedBodyNodeCursorOffset(INVALID_CURSOR_OFFSET);
}

/**
 * A global util function which is used by various components to pre-process and save the content of the message being composed
 * back to native code.
 *
 * @param contentNode the DOM Node which has the composed message's content
 * @param shouldPersist a boolean which indicates if the composed message's content should also be saved or not
 */
function syncComposeContent(composeContentNode, shouldPersist) {
    yMailBridge.setContent(composeContentNode.innerHTML, shouldPersist);
}

/**
 * Called by native code to update the signature when switch account.
 *
 * @param oldSignature the default signature of old selected account
 * @param newSignature the default signature of new selected account
 */
function updateSignature(oldSignature, newSignature) {
    var signatureDiv = document.getElementById(SIGNATURE_ELEMENT_ID);
    var composeContentElement = document.getElementById(COMPOSE_CONTENT_ELEMENT_ID);
    var tmpSignatureDiv = document.createElement('div')
    tmpSignatureDiv.innerHTML = oldSignature;

    if (signatureDiv && signatureDiv.innerText.trim() === tmpSignatureDiv.innerText.trim()) {
        signatureDiv.innerHTML = newSignature;
        syncComposeContent(composeContentElement, false);
    }
}

/**
 * Called by native code to display security notification for user reply-to set
 *
 * @param header is the header shown in the security notification
 * @param body is the body text shown in the security notification
 */
function showSecurityBoxUser(title, body, email, help, close) {
    var securityNotificationElement = document.getElementById(SECURITY_NOTIFICATION_BOX_USER_ID);
    var securityNotificationTitleElement = document.getElementById(SECURITY_NOTIFICATION_TITLE_USER_ID);
    var securityNotificationBodyElement = document.getElementById(SECURITY_NOTIFICATION_BODY_TEXT_ID);
    var securityNotificationBodyEmailElement = document.getElementById(SECURITY_NOTIFICATION_BODY_EMAIL_USER_ID);

    var securityNotificationHelpElement = document.getElementById(SECURITY_NOTIFICATION_HELP_ID);
    var securityNotificationCloseElement = document.getElementById(SECURITY_NOTIFICATION_CLOSE_ID);

    securityNotificationElement.style.display = 'block';
    securityNotificationTitleElement.innerHTML = title;
    securityNotificationBodyElement.innerHTML = body;
    securityNotificationBodyEmailElement.innerHTML = email;

    securityNotificationHelpElement.setAttribute('aria-label', help);
    securityNotificationCloseElement.setAttribute('aria-label', close);
}

/**
 * Called by native code to hide security notification for user
 *
 */
function hideSecurityNotificationUser() {
    document.getElementById(SECURITY_NOTIFICATION_BOX_USER_ID).style.display = 'none';
}

function hideSecurityNotificationUserAndLog() {
    hideSecurityNotificationUser();
    yMailBridge.logSecurityNotificationUserClose();
}

function replyToWarningInfoClicked() {
    yMailBridge.replyToWarningInfoClicked();
}

function toggleComposeHeader(composeMode) {
    var composeHeaderElement = document.getElementById(COMPOSE_HEADER_ELEMENT_ID);
    if (!composeMode) {
        composeHeaderElement.classList.add('hidden');
    } else {
        composeHeaderElement.classList.remove('hidden');
    }
}

/**
 * Wrapper for apply stationery, handles both normal case and NONE case
 * Sync the message body after stationery applied
 *
 * @param themeId stationery theme id, if it is "NONE", clear stationery
 */

function applyStationery(themeId) {
    var composeContentElement = document.getElementById(COMPOSE_CONTENT_ELEMENT_ID),
        clearStationeryButton,
        currentCaretPosition,
        currentFocusedNodeIdAndText;

    currentFocusedNodeIdAndText = composeContentFocusController.getFocusedNodeIdAndText();
    currentCaretPosition = composeContentFocusController.getCaretPosition();

    if (themeId === NONE_STATIONERY_ID) {
        Stationery.clearStationery();
    } else {
        Stationery.applyStationery(themeId);
        clearStationeryButton = document.querySelector('.' + Stationery.constants.rteStationeryCoreClassName + ' .' + Stationery.constants.clearStationeryClassName);

        if (clearStationeryButton) {
            // Add a listener to reset cursor position and re-attach the remove btn event after clear the stationery
            clearStationeryButton.addEventListener('click', function() {
                resetCursorPositionAfterStationeryChange(currentFocusedNodeIdAndText, currentCaretPosition, NONE_STATIONERY_ID);
                setTimeout(attachInlineElementHandler(), 0);
            });
        }
    }

    attachInlineElementHandler(composeContentElement);
    resetCursorPositionAfterStationeryChange(currentFocusedNodeIdAndText, currentCaretPosition, themeId);
    syncComposeContent(composeContentElement, false);
}

/**
 * Attach the remove event back to the card view and more button to inline-image after apply/remove stationery
 */
function attachInlineElementHandler() {
    var composeContentElement = document.getElementById(COMPOSE_CONTENT_ELEMENT_ID),
        imgNodeList = document.getElementsByTagName('img'),
        imgVC;

    // re-attach remove button to card element
    attachmentsController.initAttachmentCards(composeContentElement);

    // Re-attach image controller
    for (var i = 0; i < imgNodeList.length; i++) {
        imgVC = new ImageViewController();
        imgVC.attach(imgNodeList.item(i));
    }
}

/**
 * Set the cursor back to where it was before stationery change
 *
 * @param currentFocusedNodeIdAndText element and text node that cursor was in before stationery change
 * @param caretPosition caret position in the container element before stationery change
 * @param themeId Id for the new stationery theme
 */
function resetCursorPositionAfterStationeryChange(currentFocusedNodeIdAndText, caretPosition, themeId) {
    // If we clear stationery, need to set the container element Id back to the original compose body from stationery compose body
    if (themeId && themeId !== NONE_STATIONERY_ID && currentFocusedNodeIdAndText.elementId === COMPOSE_CONTENT_ELEMENT_ID) {
        currentFocusedNodeIdAndText.elementId = STATIONERY_BODY_ID;
    } else if (currentFocusedNodeIdAndText.elementId === STATIONERY_BODY_ID && themeId === NONE_STATIONERY_ID) {
        currentFocusedNodeIdAndText.elementId = COMPOSE_CONTENT_ELEMENT_ID;
    }

    // If the element ID is still null, set to default value
    if (!currentFocusedNodeIdAndText.elementId) {
        currentFocusedNodeIdAndText.elementId = themeId && themeId !== NONE_STATIONERY_ID ? STATIONERY_BODY_ID : COMPOSE_CONTENT_ELEMENT_ID;
    }

    composeContentFocusController.setBodyFocusAtPosition(currentFocusedNodeIdAndText.elementId, currentFocusedNodeIdAndText.nodeText, caretPosition);
}

/**
* Sync compose body with native message model
*/
function syncComposeBody() {
    syncComposeContent(document.getElementById(COMPOSE_CONTENT_ELEMENT_ID));
}

// Bind Document event listeners responsible for communicating events back to the Java runtime
documentEventBridge.bindEventListeners();
